<?php
/* Copyright (C) 2004-2013  Laurent Destailleur <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012  Regis Houssin       <regis.houssin@capnetworks.com>
 * Copyright (C) 2014       Raphaël Doursenaud  <rdoursenaud@gpcsolutions.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *	    \file       htdocs/core/boxes/modules_boxes.php
 *		\ingroup    facture
 *		\brief      Fichier contenant la classe mere des boites
 */


/**
 * Class ModeleBoxes
 *
 * Boxes parent class
 */
class ModeleBoxes    // Can't be abtract as it is instantiated to build "empty" boxes
{
	/**
	 * @var DoliDB Database handler
	 */
	public $db;

	/**
	 * @var string Error message
	 */
	public $error = '';

	/**
	 * @var int Maximum lines
	 */
	public $max = 5;

	/**
	 * @var int Status
	 */
	public $enabled=1;

	/**
	 * @var int Box definition database ID
	 */
	public $rowid;

	/**
	 * @var int ID
	 * @deprecated Same as box_id?
	 */
	public $id;

	/**
	 * @var int Position?
	 */
	public $position;

	/**
	 * @var string Display order
	 */
	public $box_order;

	/**
	 * @var int User ID
	 */
	public $fk_user;

	/**
	 * @var string Source file
	 */
	public $sourcefile;

	/**
	 * @var string Class name
	 */
	public $class;

	/**
	 * @var string ID
	 */
	public $box_id;

	/**
	 * @var string Alphanumeric ID
	 */
	public $boxcode;

	/**
	 * @var string Note
	 */
	public $note;

	/**
	 * Constructor
	 *
	 * @param   DoliDB  $db     Database handler
     * @param   string  $param  More parameters
	 */
	function __construct($db,$param='')
	{
		$this->db=$db;
	}

	/**
	 * Return last error message
	 *
	 * @return  string  Error message
	 */
	function error()
	{
		return $this->error;
	}


	/**
	 * Load a box line from its rowid
	 *
	 * @param   int $rowid  Row id to load
	 *
	 * @return  int         <0 if KO, >0 if OK
	 */
	function fetch($rowid)
	{
		global $conf;

		// Recupere liste des boites d'un user si ce dernier a sa propre liste
		$sql = "SELECT b.rowid, b.box_id, b.position, b.box_order, b.fk_user";
		$sql.= " FROM ".MAIN_DB_PREFIX."boxes as b";
		$sql.= " WHERE b.entity = ".$conf->entity;
		$sql.= " AND b.rowid = ".$rowid;
		dol_syslog(get_class($this)."::fetch rowid=".$rowid);

		$resql = $this->db->query($sql);
		if ($resql)
		{
			$obj = $this->db->fetch_object($resql);
			if ($obj)
			{
				$this->rowid=$obj->rowid;
				$this->box_id=$obj->box_id;
				$this->position=$obj->position;
				$this->box_order=$obj->box_order;
				$this->fk_user=$obj->fk_user;
				return 1;
			}
			else
			{
				return -1;
			}
		}
		else
		{
			return -1;
		}
	}


	/**
	 *Standard method to show a box (usage by boxes not mandatory, a box can still use its own showBox function)
	 *
	 * @param   array   $head       Array with properties of box title
	 * @param   array   $contents   Array with properties of box lines
	 *
	 * @return  void
	 */
	function showBox($head, $contents)
	{
		global $langs,$conf;

		$MAXLENGTHBOX=60;   // Mettre 0 pour pas de limite
		$bcx=array();
		$bcx[0] = 'class="box_pair"';
		$bcx[1] = 'class="box_impair"';
		$var = false;

		dol_syslog(get_class($this).'::showBox');

		// Define nbcol and nblines of the box to show
		$nbcol=0;
		if (isset($contents[0])) $nbcol=count($contents[0]);
		$nblines=count($contents);

		print "\n\n<!-- Box start -->\n";
		print '<div class="box" id="boxto_'.$this->box_id.'">'."\n";

		if (! empty($head['text']) || ! empty($head['sublink']) || ! empty($head['subpicto']) || $nblines)
		{
			print '<table summary="boxtable'.$this->box_id.'" width="100%" class="noborder boxtable">'."\n";
		}

		// Show box title
		if (! empty($head['text']) || ! empty($head['sublink']) || ! empty($head['subpicto']))
		{
			//print '<div id="boxto_'.$this->box_id.'_title">'."\n";
			//print '<table summary="boxtabletitle'.$this->box_id.'" width="100%" class="noborder">'."\n";
			print '<tr class="box_titre">';
			print '<td';
			if ($nbcol > 0) { print ' colspan="'.$nbcol.'"'; }
			print '>';
			if ($conf->use_javascript_ajax)
			{
				print '<table summary="" class="nobordernopadding" width="100%"><tr><td>';
			}
			if (! empty($head['text']))
			{
				$s=dol_trunc($head['text'],isset($head['limit'])?$head['limit']:$MAXLENGTHBOX);
				print $s;
			}
			print ' ';
			if (! empty($head['sublink'])) print '<a href="'.$head['sublink'].'"'.(empty($head['target'])?' target="_blank"':'').'>';
			if (! empty($head['subpicto'])) print img_picto($head['subtext'], $head['subpicto'], 'class="'.(empty($head['subclass'])?'':$head['subclass']).'" id="idsubimg'.$this->boxcode.'"');
			if (! empty($head['sublink'])) '</a>';
			if (! empty($conf->use_javascript_ajax))
			{
				print '</td><td class="nocellnopadd boxclose nowrap">';
				// The image must have the class 'boxhandle' beause it's value used in DOM draggable objects to define the area used to catch the full object
				print img_picto($langs->trans("MoveBox",$this->box_id),'grip_title','class="boxhandle hideonsmartphone" style="cursor:move;"');
				print img_picto($langs->trans("Close2",$this->box_id),'close_title','class="boxclose" rel="x:y" style="cursor:pointer;" id="imgclose'.$this->box_id.'"');
				$label=$head['text'];
				if (! empty($head['graph'])) $label.=' ('.$langs->trans("Graph").')';
				print '<input type="hidden" id="boxlabelentry'.$this->box_id.'" value="'.dol_escape_htmltag($label).'">';
				print '</td></tr></table>';
			}
			print '</td>';
			print "</tr>\n";
			//print "</table>\n";
			//print "</div>\n";
		}

		// Show box lines
		if ($nblines)
		{
			//print '<table summary="boxtablelines'.$this->box_id.'" width="100%" class="noborder">'."\n";
			// Loop on each record
			for ($i=0, $n=$nblines; $i < $n; $i++)
			{
				if (isset($contents[$i]))
				{
					$var=!$var;

					// TR
					if (isset($contents[$i][0]['tr'])) print '<tr valign="top" '.$contents[$i][0]['tr'].'>';
					else print '<tr valign="top" '.$bcx[$var].'>';

					// Loop on each TD
					$nbcolthisline=count($contents[$i]);
					for ($j=0; $j < $nbcolthisline; $j++)
					{
						// Define tdparam
						$tdparam='';
						if (isset($contents[$i][$j]['td'])) $tdparam.=' '.$contents[$i][$j]['td'];

						if (empty($contents[$i][$j]['text'])) $contents[$i][$j]['text']="";
						$text=isset($contents[$i][$j]['text'])?$contents[$i][$j]['text']:'';
						$textwithnotags=preg_replace('/<([^>]+)>/i','',$text);
						$text2=isset($contents[$i][$j]['text2'])?$contents[$i][$j]['text2']:'';
						$text2withnotags=preg_replace('/<([^>]+)>/i','',$text2);
						$textnoformat=isset($contents[$i][$j]['textnoformat'])?$contents[$i][$j]['textnoformat']:'';
						//print "xxx $textwithnotags y";

						print '<td'.$tdparam.'>';

						// Url
						if (! empty($contents[$i][$j]['url']))
						{
							print '<a href="'.$contents[$i][$j]['url'].'" title="'.$textwithnotags.'"';
							//print ' alt="'.$textwithnotags.'"';      // Pas de alt sur un "<a href>"
							print isset($contents[$i][$j]['target'])?' target="'.$contents[$i][$j]['target'].'"':'';
							print '>';
						}

						// Logo
						if (! empty($contents[$i][$j]['logo']))
						{
							$logo=preg_replace("/^object_/i","",$contents[$i][$j]['logo']);
							print img_object($langs->trans("Show"),$logo);
						}

						$maxlength=$MAXLENGTHBOX;
						if (! empty($contents[$i][$j]['maxlength'])) $maxlength=$contents[$i][$j]['maxlength'];

						if ($maxlength) $textwithnotags=dol_trunc($textwithnotags,$maxlength);
						if (preg_match('/^<img/i',$text) || ! empty($contents[$i][$j]['asis'])) print $text;	// show text with no html cleaning
						else print $textwithnotags;				// show text with html cleaning

						// End Url
						if (! empty($contents[$i][$j]['url'])) print '</a>';

						if (preg_match('/^<img/i',$text2) || ! empty($contents[$i][$j]['asis2'])) print $text2;	// show text with no html cleaning
						else print $text2withnotags;				// show text with html cleaning

						if (! empty($textnoformat)) print "\n".$textnoformat."\n";

						print "</td>";
					}

					print "</tr>\n";
				}
			}
		}

		if (! empty($head['text']) || ! empty($head['sublink']) || ! empty($head['subpicto']) || $nblines)
		{
			print "</table>\n";
		}

		// If invisible box with no contents
		if (empty($head['text']) && empty($head['sublink']) && empty($head['subpicto']) && ! $nblines) print "<br>\n";

		print "</div>\n";
		print "<!-- Box end -->\n\n";
	}

}


